

<?php $__env->startSection('title', 'Accounts'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Accounts</h1>
        <p class="text-muted">Manage your organization's financial accounts</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('accounts.create')); ?>" class="btn btn-primary">+ Add Account</a>
    </div>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Account Name</th>
                <th>Type</th>
                <th>Organization</th>
                <th>Balance</th>
                <th>Currency</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><strong><?php echo e($account->name); ?></strong></td>
                <td><span class="badge badge-info"><?php echo e($account->type); ?></span></td>
                <td><?php echo e($account->organization?->name); ?></td>
                <td class="<?php echo e($account->balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                    <?php echo e(number_format($account->balance, 2)); ?>

                </td>
                <td><?php echo e($account->currency); ?></td>
                <td>
                    <div class="action-buttons">
                        <a href="<?php echo e(route('accounts.edit', $account)); ?>" class="btn btn-sm btn-link">✏️</a>
                        <form action="<?php echo e(route('accounts.destroy', $account)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Delete this account?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-link">🗑️</button>
                        </form>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="empty-state">No accounts found. Create your first account.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($accounts->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/finance/accounts/index.blade.php ENDPATH**/ ?>