

<?php $__env->startSection('title', 'Budgets'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Budgets</h1>
        <p class="text-muted">Annual financial plans and budgets</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('budgets.create')); ?>" class="btn btn-primary">+ Create Budget</a>
    </div>
</div>

<div class="filters-card">
    <form action="<?php echo e(route('budgets.index')); ?>" method="GET" class="filters-form">
        <div class="filter-group">
            <select name="year">
                <option value="">All Years</option>
                <?php for($y = date('Y') + 1; $y >= 2020; $y--): ?>
                <option value="<?php echo e($y); ?>" <?php echo e(request('year') == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                <?php endfor; ?>
            </select>
        </div>
        <div class="filter-group">
            <select name="status">
                <option value="">All Statuses</option>
                <option value="Draft" <?php echo e(request('status') == 'Draft' ? 'selected' : ''); ?>>Draft</option>
                <option value="Approved" <?php echo e(request('status') == 'Approved' ? 'selected' : ''); ?>>Approved</option>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Organization</th>
                <th>Fiscal Year</th>
                <th>Total Income</th>
                <th>Total Expense</th>
                <th>Net Balance</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $budgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><strong><?php echo e($budget->organization?->name); ?></strong></td>
                <td><?php echo e($budget->fiscal_year); ?></td>
                <td class="text-success"><?php echo e(number_format($budget->total_income, 2)); ?></td>
                <td class="text-danger"><?php echo e(number_format($budget->total_expense, 2)); ?></td>
                <td class="<?php echo e($budget->net_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                    <?php echo e(number_format($budget->net_balance, 2)); ?>

                </td>
                <td>
                    <?php if($budget->status === 'Draft'): ?>
                        <span class="badge badge-warning">Draft</span>
                    <?php else: ?>
                        <span class="badge badge-success">Approved</span>
                    <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route('budgets.show', $budget)); ?>" class="btn btn-sm btn-link">👁️</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" class="empty-state">No budgets found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($budgets->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/budgets/index.blade.php ENDPATH**/ ?>