

<?php $__env->startSection('title', 'Members'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Members</h1>
        <p class="text-muted">Manage your organization's members</p>
    </div>
    <div class="header-actions">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('members.export')): ?>
        <a href="<?php echo e(route('members.export', request()->query())); ?>" class="btn btn-secondary">Export CSV</a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('members.create')): ?>
        <a href="<?php echo e(route('members.create')); ?>" class="btn btn-primary">+ Add Member</a>
        <?php endif; ?>
    </div>
</div>

<!-- Filters -->
<div class="filters-card">
    <form action="<?php echo e(route('members.index')); ?>" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search name, email, phone..." value="<?php echo e(request('search')); ?>">
        </div>
        <div class="filter-group">
            <select name="status">
                <option value="">All Status</option>
                <option value="Active" <?php echo e(request('status') == 'Active' ? 'selected' : ''); ?>>Active</option>
                <option value="Inactive" <?php echo e(request('status') == 'Inactive' ? 'selected' : ''); ?>>Inactive</option>
                <option value="Suspended" <?php echo e(request('status') == 'Suspended' ? 'selected' : ''); ?>>Suspended</option>
                <option value="Left" <?php echo e(request('status') == 'Left' ? 'selected' : ''); ?>>Left</option>
            </select>
        </div>
        <div class="filter-group">
            <select name="category">
                <option value="">All Categories</option>
                <option value="Professional" <?php echo e(request('category') == 'Professional' ? 'selected' : ''); ?>>Professional</option>
                <option value="Student" <?php echo e(request('category') == 'Student' ? 'selected' : ''); ?>>Student</option>
                <option value="Entrepreneur" <?php echo e(request('category') == 'Entrepreneur' ? 'selected' : ''); ?>>Entrepreneur</option>
                <option value="Other" <?php echo e(request('category') == 'Other' ? 'selected' : ''); ?>>Other</option>
            </select>
        </div>
        <div class="filter-group">
            <select name="organization_id">
                <option value="">All Organizations</option>
                <?php $__currentLoopData = $organizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($org->id); ?>" <?php echo e(request('organization_id') == $org->id ? 'selected' : ''); ?>><?php echo e($org->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
        <a href="<?php echo e(route('members.index')); ?>" class="btn btn-link">Clear</a>
    </form>
</div>

<!-- Members Table -->
<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Contact</th>
                <th>Organization</th>
                <th>Category</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td>
                    <a href="<?php echo e(route('members.show', $member)); ?>" class="member-name">
                        <?php echo e($member->full_name); ?>

                    </a>
                </td>
                <td>
                    <div class="contact-info">
                        <?php if($member->phone): ?><span>📱 <?php echo e($member->phone); ?></span><?php endif; ?>
                        <?php if($member->email): ?><span>✉️ <?php echo e($member->email); ?></span><?php endif; ?>
                    </div>
                </td>
                <td><?php echo e($member->organization?->name); ?></td>
                <td><span class="badge badge-info"><?php echo e($member->category); ?></span></td>
                <td>
                    <span class="badge badge-<?php echo e($member->status == 'Active' ? 'success' : ($member->status == 'Suspended' ? 'danger' : 'warning')); ?>">
                        <?php echo e($member->status); ?>

                    </span>
                </td>
                <td>
                    <div class="action-buttons">
                        <a href="<?php echo e(route('members.show', $member)); ?>" class="btn btn-sm btn-link" title="View">👁️</a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('members.edit')): ?>
                        <a href="<?php echo e(route('members.edit', $member)); ?>" class="btn btn-sm btn-link" title="Edit">✏️</a>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('members.delete')): ?>
                        <form action="<?php echo e(route('members.destroy', $member)); ?>" method="POST" style="display:inline;" data-confirm="Are you sure you want to delete this member?">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-link" title="Delete">🗑️</button>
                        </form>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="empty-state">No members found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($members->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/members/index.blade.php ENDPATH**/ ?>