

<?php $__env->startSection('title', 'Record Contribution'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h1>Record Contribution</h1>
    <p class="text-muted">Record a member payment or contribution</p>
</div>

<div class="form-card">
    <form action="<?php echo e(route('contributions.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
            <label for="member_id">Member *</label>
            <select id="member_id" name="member_id" required onchange="loadPledges()">
                <option value="">Select Member...</option>
                <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($member->id); ?>" <?php echo e(old('member_id', request('member_id')) == $member->id ? 'selected' : ''); ?>>
                    <?php echo e($member->full_name); ?> (<?php echo e($member->organization?->name); ?>)
                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php $__errorArgs = ['member_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <?php if($pledges->count() > 0): ?>
        <div class="form-group">
            <label for="pledge_id">Apply to Pledge (Optional)</label>
            <select id="pledge_id" name="pledge_id">
                <option value="">No pledge - General contribution</option>
                <?php $__currentLoopData = $pledges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pledge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($pledge->id); ?>" <?php echo e(old('pledge_id', request('pledge_id')) == $pledge->id ? 'selected' : ''); ?>>
                    <?php echo e($pledge->purpose); ?> (<?php echo e($pledge->year); ?>) - Remaining: <?php echo e(number_format($pledge->remaining, 2)); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        
        <div class="form-row">
            <div class="form-group">
                <label for="amount">Amount *</label>
                <div class="currency-input">
                    <input type="number" id="amount" name="amount" value="<?php echo e(old('amount')); ?>" step="0.01" min="1" required placeholder="0.00">
                </div>
                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="form-group">
                <label for="date">Date *</label>
                <input type="date" id="date" name="date" value="<?php echo e(old('date', date('Y-m-d'))); ?>" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="purpose">Purpose *</label>
            <input type="text" id="purpose" name="purpose" value="<?php echo e(old('purpose')); ?>" required placeholder="e.g., Monthly Tithe, Building Fund">
            <?php $__errorArgs = ['purpose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="account_id">Receive into Account *</label>
                <select id="account_id" name="account_id" required>
                    <option value="">Select Account...</option>
                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($account->id); ?>" <?php echo e(old('account_id') == $account->id ? 'selected' : ''); ?>>
                        <?php echo e($account->name); ?> (<?php echo e($account->currency); ?>)
                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="form-group">
                <label for="category_id">Category *</label>
                <select id="category_id" name="category_id" required>
                    <option value="">Select Category...</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                        <?php echo e($category->name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        
        <div class="form-group">
            <label for="reference">Reference Number</label>
            <input type="text" id="reference" name="reference" value="<?php echo e(old('reference')); ?>" placeholder="e.g., Receipt #12345">
        </div>
        
        <div class="form-actions">
            <a href="<?php echo e(route('contributions.index')); ?>" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Record Contribution</button>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function loadPledges() {
    const memberId = document.getElementById('member_id').value;
    if (memberId) {
        window.location.href = '<?php echo e(route('contributions.create')); ?>?member_id=' + memberId;
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/payments/contributions/create.blade.php ENDPATH**/ ?>