

<?php $__env->startSection('title', 'Contributions'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Contributions</h1>
        <p class="text-muted">Member payments and contributions</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('contributions.create')); ?>" class="btn btn-primary">+ Record Contribution</a>
    </div>
</div>

<div class="filters-card">
    <form action="<?php echo e(route('contributions.index')); ?>" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search member..." value="<?php echo e(request('search')); ?>">
        </div>
        <div class="filter-group">
            <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>">
        </div>
        <div class="filter-group">
            <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>">
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Member</th>
                <th>Purpose</th>
                <th>Amount</th>
                <th>Pledge</th>
                <th>Account</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $contributions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contribution): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($contribution->date->format('d M Y')); ?></td>
                <td><strong><?php echo e($contribution->member?->full_name); ?></strong></td>
                <td><?php echo e($contribution->purpose); ?></td>
                <td class="text-success">+<?php echo e(number_format($contribution->amount, 2)); ?></td>
                <td>
                    <?php if($contribution->pledge): ?>
                        <a href="<?php echo e(route('pledges.show', $contribution->pledge)); ?>"><?php echo e($contribution->pledge->purpose); ?></a>
                    <?php else: ?>
                        <span class="text-muted">-</span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($contribution->transaction?->account?->name); ?></td>
                <td>
                    <a href="<?php echo e(route('contributions.show', $contribution)); ?>" class="btn btn-sm btn-link">👁️</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" class="empty-state">No contributions found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($contributions->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/payments/contributions/index.blade.php ENDPATH**/ ?>