

<?php $__env->startSection('title', 'Edit Role'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Edit Role: <?php echo e($role->name); ?></h1>
        <p class="text-muted">Modify role permissions</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('settings.index', ['tab' => 'roles'])); ?>" class="btn btn-secondary">Cancel</a>
        <?php if($role->name !== 'Super Admin' && $role->users->count() === 0): ?>
        <form action="<?php echo e(route('roles.destroy', $role)); ?>" method="POST" style="display:inline;" data-confirm="Are you sure you want to delete this role?">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" class="btn btn-danger">Delete Role</button>
        </form>
        <?php endif; ?>
    </div>
</div>

<form action="<?php echo e(route('roles.update', $role)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    
    <div class="card" style="margin-bottom: 2rem;">
        <div class="form-group">
            <label for="name">Role Name *</label>
            <input type="text" id="name" name="name" class="form-control" value="<?php echo e($role->name); ?>" required placeholder="e.g. Treasurer" style="max-width: 400px;">
        </div>
    </div>

    <div class="card">
        <h3>Permissions</h3>
        <p class="text-muted" style="margin-bottom: 1.5rem;">Select the capabilities for this role.</p>

        <div class="permissions-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1.5rem;">
            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $perms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="permission-group" style="background: var(--bg-tertiary); padding: 1rem; border-radius: 8px;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.75rem; border-bottom: 1px solid var(--border-color); padding-bottom: 0.5rem;">
                    <h4 style="margin: 0; text-transform: capitalize;"><?php echo e($group); ?></h4>
                    <label style="font-size: 0.8rem; cursor: pointer;">
                        <input type="checkbox" onchange="toggleGroup(this)"> Select All
                    </label>
                </div>
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                    <?php $__currentLoopData = $perms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="checkbox-wrapper" style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.9rem; cursor: pointer;">
                        <input type="checkbox" name="permissions[]" value="<?php echo e($perm->name); ?>" <?php echo e($role->hasPermissionTo($perm->name) ? 'checked' : ''); ?>>
                        <?php echo e(str_replace($group . '.', '', $perm->name)); ?>

                    </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="form-actions" style="margin-top: 2rem;">
        <button type="submit" class="btn btn-primary">Update Role</button>
    </div>
</form>

<script>
    function toggleGroup(source) {
        let checkboxes = source.closest('.permission-group').querySelectorAll('input[name="permissions[]"]');
        for(let i=0; i < checkboxes.length; i++) {
            checkboxes[i].checked = source.checked;
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/settings/roles/edit.blade.php ENDPATH**/ ?>