

<?php $__env->startSection('title', 'Create Budget'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h1>Create New Budget</h1>
    <p class="text-muted">Create an annual financial plan</p>
</div>

<div class="form-card">
    <form action="<?php echo e(route('budgets.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
            <label for="organization_id">Organization *</label>
            <select id="organization_id" name="organization_id" required>
                <option value="">Select Organization...</option>
                <?php $__currentLoopData = $organizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($org->id); ?>" <?php echo e(old('organization_id') == $org->id ? 'selected' : ''); ?>>
                    <?php echo e($org->name); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php $__errorArgs = ['organization_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="form-group">
            <label for="fiscal_year">Fiscal Year *</label>
            <select id="fiscal_year" name="fiscal_year" required>
                <?php for($y = date('Y') + 1; $y >= date('Y') - 2; $y--): ?>
                <option value="<?php echo e($y); ?>" <?php echo e(old('fiscal_year', date('Y')) == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                <?php endfor; ?>
            </select>
            <?php $__errorArgs = ['fiscal_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="form-actions">
            <a href="<?php echo e(route('budgets.index')); ?>" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Budget</button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/budgets/create.blade.php ENDPATH**/ ?>