

<?php $__env->startSection('title', 'Budget Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1><?php echo e($budget->organization?->name); ?> - <?php echo e($budget->fiscal_year); ?></h1>
        <div style="display: flex; gap: 1rem; align-items: center;">
            <p class="text-muted" style="margin: 0;">Status: 
                <?php if($budget->status === 'Draft'): ?>
                    <span class="badge badge-warning">Draft</span>
                <?php elseif($budget->status === 'Pending'): ?>
                    <span class="badge badge-info">Pending Approval</span>
                <?php elseif($budget->status === 'Approved'): ?>
                    <span class="badge badge-success">Approved</span>
                <?php elseif($budget->status === 'Amendment Pending'): ?>
                    <span class="badge badge-warning">Amendment Requested</span>
                <?php endif; ?>
            </p>
            <?php if($budget->rejection_reason && $budget->status === 'Draft'): ?>
                <div class="alert alert-error" style="margin: 0; padding: 0.25rem 0.5rem; font-size: 0.85rem;">
                    <strong>Rejection Reason:</strong> <?php echo e($budget->rejection_reason); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="header-actions">
        
        <?php if($budget->status === 'Draft'): ?>
            <form action="<?php echo e(route('budgets.submit', $budget)); ?>" method="POST" style="display:inline;" data-confirm="Submit this budget for approval? You will not be able to edit it afterward.">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-primary">📤 Submit for Approval</button>
            </form>
        <?php endif; ?>

        
        <?php if($budget->status === 'Pending'): ?>
            <?php if(Auth::id() !== $budget->creator_id): ?>
                <form action="<?php echo e(route('budgets.approve', $budget)); ?>" method="POST" style="display:inline;" data-confirm="Approve this budget?">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">✅ Approve</button>
                </form>
                <button type="button" class="btn btn-danger" onclick="promptReject()">❌ Reject</button>
                
                <form id="reject-form" action="<?php echo e(route('budgets.reject', $budget)); ?>" method="POST" style="display:none;">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="reason" id="reject-reason">
                </form>
            <?php else: ?>
                <button class="btn btn-secondary" disabled title="You cannot approve your own submission">⏳ Awaiting Approval</button>
            <?php endif; ?>
        <?php endif; ?>

        
        <?php if($budget->status === 'Approved'): ?>
            <form action="<?php echo e(route('budgets.request-amendment', $budget)); ?>" method="POST" style="display:inline;" data-confirm="Request to unpublish/amend this budget?">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-secondary">🔓 Request Amendment</button>
            </form>
        <?php endif; ?>

        
        <?php if($budget->status === 'Amendment Pending'): ?>
            <?php if(Auth::id() !== $budget->creator_id): ?>
                <form action="<?php echo e(route('budgets.grant-amendment', $budget)); ?>" method="POST" style="display:inline;" data-confirm="Grant amendment request? Budget will return to Draft.">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-warning">🔓 Grant Amendment</button>
                </form>
            <?php else: ?>
                 <button class="btn btn-secondary" disabled>⏳ Amendment Pending</button>
            <?php endif; ?>
        <?php endif; ?>

        <a href="<?php echo e(route('budgets.index')); ?>" class="btn btn-secondary">Back to List</a>
    </div>
</div>

<script>
    function promptReject() {
        let reason = prompt("Please provide a reason for rejection:");
        if (reason) {
            document.getElementById('reject-reason').value = reason;
            document.getElementById('reject-form').submit();
        }
    }
</script>

<!-- Summary Cards -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <div class="stat-card">
        <div class="stat-value text-success"><?php echo e(number_format($budget->total_income, 2)); ?></div>
        <div class="stat-label">Total Income</div>
    </div>
    <div class="stat-card">
        <div class="stat-value text-danger"><?php echo e(number_format($budget->total_expense, 2)); ?></div>
        <div class="stat-label">Total Expense</div>
    </div>
    <div class="stat-card">
        <div class="stat-value <?php echo e($budget->net_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
            <?php echo e(number_format($budget->net_balance, 2)); ?>

        </div>
        <div class="stat-label">Net Balance</div>
    </div>
</div>

<div class="profile-grid">
    <!-- Income Items -->
    <div class="sidebar-card">
        <h3>📈 Planned Income Targets</h3>
        <p class="text-muted" style="font-size: 0.8rem; margin-bottom: 1rem;">These are targets, not actual transactions.</p>
        <?php $__empty_1 = true; $__currentLoopData = $incomeItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="stat-item" style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong><?php echo e($item->category?->name); ?></strong>
                <?php if($item->description): ?><br><small class="text-muted"><?php echo e($item->description); ?></small><?php endif; ?>
            </div>
            <div style="display: flex; align-items: center; gap: 0.5rem;">
                <span class="text-success"><?php echo e(number_format($item->amount, 2)); ?></span>
                <?php if($budget->status === 'Draft'): ?>
                <form action="<?php echo e(route('budgets.items.destroy', [$budget, $item])); ?>" method="POST" style="display:inline;" data-confirm="Remove this item?">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-link">🗑️</button>
                </form>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No income items.</p>
        <?php endif; ?>
    </div>

    <!-- Expense Items -->
    <div class="sidebar-card">
        <h3>📉 Planned Expense Targets</h3>
        <p class="text-muted" style="font-size: 0.8rem; margin-bottom: 1rem;">These are targets, not actual transactions.</p>
        <?php $__empty_1 = true; $__currentLoopData = $expenseItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="stat-item" style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong><?php echo e($item->category?->name); ?></strong>
                <?php if($item->description): ?><br><small class="text-muted"><?php echo e($item->description); ?></small><?php endif; ?>
            </div>
            <div style="display: flex; align-items: center; gap: 0.5rem;">
                <span class="text-danger"><?php echo e(number_format($item->amount, 2)); ?></span>
                <?php if($budget->status === 'Draft'): ?>
                <form action="<?php echo e(route('budgets.items.destroy', [$budget, $item])); ?>" method="POST" style="display:inline;" data-confirm="Remove this item?">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-link">🗑️</button>
                </form>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No expense items.</p>
        <?php endif; ?>
    </div>
</div>

<?php if($budget->status === 'Draft'): ?>
<!-- Add Item Form -->
<div class="form-card" style="margin-top: 2rem;">
    <h3>Add Budget Item</h3>
    <form action="<?php echo e(route('budgets.items.store', $budget)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="form-row">
            <div class="form-group">
                <label for="category_id">Category *</label>
                <select id="category_id" name="category_id" required>
                    <option value="">Select Category...</option>
                    <optgroup label="Income">
                        <?php $__currentLoopData = $categories->where('type', 'Income'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>
                    <optgroup label="Expense">
                        <?php $__currentLoopData = $categories->where('type', 'Expense'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </optgroup>
                </select>
            </div>
            <div class="form-group">
                <label for="amount">Amount *</label>
                <div class="currency-input">
                    <input type="number" id="amount" name="amount" step="0.01" min="0.01" required placeholder="0.00">
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for="description">Description</label>
            <input type="text" id="description" name="description" placeholder="Optional notes...">
        </div>
        <button type="submit" class="btn btn-primary">Add Item</button>
    </form>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/budgets/show.blade.php ENDPATH**/ ?>