

<?php $__env->startSection('title', $organization->name); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <!-- Breadcrumb -->
        <nav style="font-size: 0.85rem; margin-bottom: 0.5rem;">
            <?php $__currentLoopData = $organization->breadcrumb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ancestor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(!$loop->last): ?>
                    <a href="<?php echo e(route('organizations.show', $ancestor)); ?>"><?php echo e($ancestor->name); ?></a>
                    <span style="margin: 0 0.5rem;">›</span>
                <?php else: ?>
                    <span><?php echo e($ancestor->name); ?></span>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </nav>
        <h1><?php echo e($organization->name); ?></h1>
        <p class="text-muted">
            <span class="badge badge-<?php echo e($organization->level?->slug == 'national' ? 'primary' : ($organization->level?->slug == 'zonal' ? 'success' : ($organization->level?->slug == 'jimbo' ? 'warning' : 'info'))); ?>">
                <?php echo e($organization->level?->name); ?>

            </span>
            <?php if($organization->code): ?>
            <span style="margin-left: 0.5rem;"><?php echo e($organization->code); ?></span>
            <?php endif; ?>
            <?php if($organization->location): ?>
            <span style="margin-left: 0.5rem;">📍 <?php echo e($organization->location); ?></span>
            <?php endif; ?>
        </p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('organizations.edit', $organization)); ?>" class="btn btn-secondary">✏️ Edit</a>
        <a href="<?php echo e(route('organizations.create', ['parent_id' => $organization->id])); ?>" class="btn btn-primary">+ Add Sub-Organization</a>
    </div>
</div>

<!-- Statistics -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <div class="stat-card">
        <div class="stat-value"><?php echo e($organization->direct_member_count); ?></div>
        <div class="stat-label">Direct Members</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?php echo e($organization->total_member_count); ?></div>
        <div class="stat-label">Total Members (incl. sub-orgs)</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?php echo e($organization->children->count()); ?></div>
        <div class="stat-label">Sub-Organizations</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?php echo e(number_format($organization->total_contributions, 0)); ?></div>
        <div class="stat-label">Total Contributions (TZS)</div>
    </div>
</div>

<div class="profile-grid">
    <!-- Leadership Board -->
    <div class="sidebar-card">
        <h3>👔 Leadership Board</h3>
        <?php $__empty_1 = true; $__currentLoopData = $organization->currentLeaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="stat-item" style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong><?php echo e($leader->position); ?></strong><br>
                <small><?php echo e($leader->leader_name); ?></small>
            </div>
            <form action="<?php echo e(route('organizations.leaders.destroy', [$organization, $leader])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-sm btn-link" onclick="return confirm('Remove leader?')">🗑️</button>
            </form>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No leaders assigned.</p>
        <?php endif; ?>

        <!-- Add Leader Form -->
        <form action="<?php echo e(route('organizations.leaders.store', $organization)); ?>" method="POST" style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border);">
            <?php echo csrf_field(); ?>
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <select name="member_id" required style="font-size: 0.85rem;">
                    <option value="">Select Member...</option>
                    <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($member->id); ?>"><?php echo e($member->full_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <select name="position" required style="font-size: 0.85rem;">
                    <option value="">Select Position...</option>
                    <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($pos); ?>"><?php echo e($pos); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <input type="date" name="started_at" value="<?php echo e(date('Y-m-d')); ?>" required style="font-size: 0.85rem;">
            </div>
            <button type="submit" class="btn btn-sm btn-primary">Add Leader</button>
        </form>
    </div>

    <!-- Sub-Organizations -->
    <div class="sidebar-card">
        <h3>📁 Sub-Organizations</h3>
        <?php $__empty_1 = true; $__currentLoopData = $organization->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="stat-item">
            <a href="<?php echo e(route('organizations.show', $child)); ?>"><?php echo e($child->name); ?></a>
            <span class="badge badge-<?php echo e($child->level?->slug == 'zonal' ? 'success' : ($child->level?->slug == 'jimbo' ? 'warning' : 'info')); ?>" style="margin-left: 0.5rem; font-size: 0.7rem;">
                <?php echo e($child->level?->name); ?>

            </span>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No sub-organizations.</p>
        <?php endif; ?>
    </div>
</div>

<!-- Members List -->
<?php if($organization->members->count() > 0): ?>
<div class="table-card" style="margin-top: 2rem;">
    <h3 style="padding: 1rem 1.5rem; border-bottom: 1px solid var(--border); margin: 0;">👥 Direct Members</h3>
    <table class="data-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Phone</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $organization->members->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><a href="<?php echo e(route('members.show', $member)); ?>"><?php echo e($member->full_name); ?></a></td>
                <td><?php echo e($member->phone ?? '-'); ?></td>
                <td><span class="badge badge-<?php echo e($member->status == 'Active' ? 'success' : 'secondary'); ?>"><?php echo e($member->status); ?></span></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php if($organization->members->count() > 10): ?>
    <div style="padding: 1rem; text-align: center;">
        <a href="<?php echo e(route('members.index', ['organization_id' => $organization->id])); ?>">View all <?php echo e($organization->members->count()); ?> members →</a>
    </div>
    <?php endif; ?>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/organizations/show.blade.php ENDPATH**/ ?>