

<?php $__env->startSection('title', 'Pledges'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Pledges (Ahadi)</h1>
        <p class="text-muted">Manage member commitments and pledges</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('pledges.create')); ?>" class="btn btn-primary">+ Add Pledge</a>
    </div>
</div>

<div class="filters-card">
    <form action="<?php echo e(route('pledges.index')); ?>" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search member..." value="<?php echo e(request('search')); ?>">
        </div>
        <div class="filter-group">
            <select name="year">
                <option value="">All Years</option>
                <?php for($y = date('Y'); $y >= 2020; $y--): ?>
                <option value="<?php echo e($y); ?>" <?php echo e(request('year') == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                <?php endfor; ?>
            </select>
        </div>
        <div class="filter-group">
            <select name="status">
                <option value="">All Statuses</option>
                <option value="Pending" <?php echo e(request('status') == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="Partial" <?php echo e(request('status') == 'Partial' ? 'selected' : ''); ?>>Partial</option>
                <option value="Completed" <?php echo e(request('status') == 'Completed' ? 'selected' : ''); ?>>Completed</option>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Member</th>
                <th>Year</th>
                <th>Purpose</th>
                <th>Amount</th>
                <th>Paid</th>
                <th>Progress</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $pledges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pledge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><strong><?php echo e($pledge->member?->full_name); ?></strong></td>
                <td><?php echo e($pledge->year); ?></td>
                <td><?php echo e($pledge->purpose); ?></td>
                <td><?php echo e(number_format($pledge->amount, 2)); ?></td>
                <td><?php echo e(number_format($pledge->paid_amount, 2)); ?></td>
                <td>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?php echo e($pledge->progress); ?>%; background: <?php echo e($pledge->status == 'Completed' ? 'var(--success)' : 'var(--primary)'); ?>;"></div>
                    </div>
                    <small><?php echo e($pledge->progress); ?>%</small>
                </td>
                <td>
                    <?php if($pledge->status === 'Pending'): ?>
                        <span class="badge badge-warning">Pending</span>
                    <?php elseif($pledge->status === 'Partial'): ?>
                        <span class="badge badge-info">Partial</span>
                    <?php else: ?>
                        <span class="badge badge-success">Completed</span>
                    <?php endif; ?>
                </td>
                <td>
                    <div class="action-buttons">
                        <a href="<?php echo e(route('pledges.show', $pledge)); ?>" class="btn btn-sm btn-link">👁️</a>
                        <a href="<?php echo e(route('pledges.edit', $pledge)); ?>" class="btn btn-sm btn-link">✏️</a>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="8" class="empty-state">No pledges found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($pledges->links()); ?>

    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.progress-bar {
    width: 100px;
    height: 8px;
    background: var(--bg-light);
    border-radius: 4px;
    overflow: hidden;
}
.progress-fill {
    height: 100%;
    transition: width 0.3s ease;
}
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/payments/pledges/index.blade.php ENDPATH**/ ?>