

<?php $__env->startSection('title', 'User Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <div class="header-content">
            <h1>User Management</h1>
            <p class="text-muted">Manage system access and roles</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary">
                <span class="icon">+</span> Add New User
            </a>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">👥</div>
            <div class="stat-content">
                <h3><?php echo e($users->total()); ?></h3>
                <span>Total Users</span>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">🛡️</div>
            <div class="stat-content">
                <h3><?php echo e(\Spatie\Permission\Models\Role::count()); ?></h3>
                <span>Active Roles</span>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">🟢</div>
            <div class="stat-content">
                <h3><?php echo e($users->total()); ?></h3>
                <span>Active Accounts</span>
            </div>
        </div>
    </div>

    <div class="card table-card">
        <!-- Toolbar -->
        <div class="filters-card" style="border: none; border-bottom: 1px solid var(--border-color); border-radius: 0; margin: 0;">
            <div class="filters-form">
                <div class="filter-group" style="flex: 2;">
                    <input type="text" placeholder="Search users by name or email..." class="form-control">
                </div>
                <div class="filter-group">
                    <select class="form-control">
                        <option value="">All Roles</option>
                        <?php $__currentLoopData = \Spatie\Permission\Models\Role::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <button class="btn btn-secondary">Filter</button>
            </div>
        </div>

        <div class="card-body" style="padding: 0;">
            <table class="data-table">
                <thead>
                    <tr>
                        <th style="padding-left: 2rem;">User</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th class="text-right">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="padding-left: 2rem;">
                            <div style="display: flex; align-items: center; gap: 1rem;">
                                <div class="avatar-circle" style="
                                    width: 40px; 
                                    height: 40px; 
                                    background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%); 
                                    color: white; 
                                    border-radius: 50%; 
                                    display: flex; 
                                    align-items: center; 
                                    justify-content: center; 
                                    font-weight: 600;
                                    font-size: 0.9rem;">
                                    <?php echo e(substr($user->first_name, 0, 1)); ?><?php echo e(substr($user->last_name, 0, 1)); ?>

                                </div>
                                <div>
                                    <div class="member-name"><?php echo e($user->full_name); ?></div>
                                    <div class="text-muted" style="font-size: 0.85rem;"><?php echo e($user->email); ?></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge <?php echo e($role->name === 'Super Admin' ? 'badge-danger' : 'badge-primary'); ?>">
                                    <?php echo e($role->name); ?>

                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td>
                            <?php if($user->is_active): ?>
                                <span class="badge badge-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Suspended</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-muted">
                            <?php echo e($user->created_at->format('M d, Y')); ?>

                        </td>
                        <td class="text-right">
                            <div class="action-buttons">
                                <a href="<?php echo e(route('users.edit', $user)); ?>" class="btn btn-sm btn-secondary" title="Edit">
                                    ✏️
                                </a>
                                
                                <form action="<?php echo e(route('users.toggle-status', $user)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-secondary" style="color: <?php echo e($user->is_active ? 'var(--warning)' : 'var(--success)'); ?>;" title="<?php echo e($user->is_active ? 'Suspend' : 'Activate'); ?>">
                                        <?php echo e($user->is_active ? '🚫' : '✅'); ?>

                                    </button>
                                </form>

                                <form action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" style="display:inline;" data-confirm="Are you sure you want to delete this user? This action cannot be undone.">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-secondary" style="color: var(--danger);" title="Delete">
                                        🗑️
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="pagination-wrapper">
                <?php echo e($users->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/users/index.blade.php ENDPATH**/ ?>