<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name')); ?> - <?php echo $__env->yieldContent('title', 'Dashboard'); ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/dropdown.css')); ?>">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <?php if(auth()->guard()->check()): ?>
        <nav class="navbar">
            <div class="nav-brand">
                <a href="<?php echo e(route('dashboard')); ?>"><?php echo e(config('app.name')); ?></a>
            </div>
            <div class="nav-links">
                <?php $__currentLoopData = \App\Models\Menu::getForUser(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($menu->activeChildren->isNotEmpty()): ?>
                        <div class="nav-dropdown" style="position: relative;">
                            <a href="#" class="dropdown-trigger <?php echo e(request()->is(explode('.', $menu->route)[0].'*') ? 'active' : ''); ?>" onclick="this.nextElementSibling.classList.toggle('show'); return false;">
                                <?php echo e($menu->icon); ?> <?php echo e($menu->name); ?> ▼
                            </a>
                            <div class="dropdown-content">
                                <?php $__currentLoopData = $menu->activeChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e($child->route ? route($child->route) : '#'); ?>" class="<?php echo e(request()->routeIs($child->route) ? 'active' : ''); ?>">
                                        <?php echo e($child->icon); ?> <?php echo e($child->name); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo e($menu->route ? route($menu->route) : '#'); ?>" class="<?php echo e(request()->routeIs($menu->route) ? 'active' : ''); ?>">
                            <?php echo e($menu->icon); ?> <?php echo e($menu->name); ?>

                        </a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="nav-menu">
                <div class="nav-item">
                    <span class="user-name"><?php echo e(auth()->user()->full_name); ?></span>
                </div>
                <div class="nav-item">
                    <form action="<?php echo e(route('logout')); ?>" method="POST" style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-link">Logout</button>
                    </form>
                </div>
            </div>
        </nav>
    <?php endif; ?>

    <main class="main-content">
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-error"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Global handler for confirmations
        document.addEventListener('submit', function(e) {
            if (e.target.dataset.confirm) {
                e.preventDefault();
                Swal.fire({
                    title: 'Are you sure?',
                    text: e.target.dataset.confirm,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#4f46e5', // Primary color
                    cancelButtonColor: '#ef4444', // Danger color
                    confirmButtonText: 'Yes, proceed!',
                    background: '#1f2937', // Dark bg
                    color: '#fff'
                }).then((result) => {
                    if (result.isConfirmed) {
                        e.target.submit();
                    }
                });
            }
        });

        // Handler for links with data-confirm
        document.addEventListener('click', function(e) {
            const link = e.target.closest('a[data-confirm], button[data-confirm]');
            if (link) {
                e.preventDefault();
                Swal.fire({
                    title: 'Are you sure?',
                    text: link.dataset.confirm,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#4f46e5',
                    cancelButtonColor: '#ef4444',
                    confirmButtonText: 'Yes, proceed!',
                    background: '#1f2937',
                    color: '#fff'
                }).then((result) => {
                    if (result.isConfirmed) {
                        if (link.tagName === 'BUTTON' && link.type === 'submit') {
                            link.closest('form').submit();
                        } else if (link.tagName === 'A') {
                            window.location.href = link.href;
                        }
                    }
                });
            }
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/layouts/app.blade.php ENDPATH**/ ?>