

<?php $__env->startSection('title', 'Record Transaction'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h1>Record Transaction</h1>
    <p class="text-muted">Record income or expense</p>
</div>

<div class="form-card">
    <form action="<?php echo e(route('transactions.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <div class="form-row">
            <div class="form-group">
                <label for="type">Transaction Type *</label>
                <select id="type" name="type" required>
                    <option value="Credit" <?php echo e(old('type') == 'Credit' ? 'selected' : ''); ?>>💰 Income (Credit)</option>
                    <option value="Debit" <?php echo e(old('type') == 'Debit' ? 'selected' : ''); ?>>💸 Expense (Debit)</option>
                </select>
            </div>
            <div class="form-group">
                <label for="date">Date *</label>
                <input type="date" id="date" name="date" value="<?php echo e(old('date', date('Y-m-d'))); ?>" required>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="account_id">Account *</label>
                <select id="account_id" name="account_id" required>
                    <option value="">Select Account...</option>
                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($account->id); ?>" <?php echo e(old('account_id') == $account->id ? 'selected' : ''); ?>>
                        <?php echo e($account->name); ?> (<?php echo e($account->currency); ?> <?php echo e(number_format($account->balance, 2)); ?>)
                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="form-group">
                <label for="category_id">Category *</label>
                <select id="category_id" name="category_id" required>
                    <option value="">Select Category...</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                        <?php echo e($category->name); ?> (<?php echo e($category->type); ?>)
                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="amount">Amount *</label>
                <div class="currency-input">
                    <input type="number" id="amount" name="amount" value="<?php echo e(old('amount')); ?>" step="0.01" min="0.01" required placeholder="0.00">
                </div>
                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="form-group">
                <label for="reference">Reference Number</label>
                <input type="text" id="reference" name="reference" value="<?php echo e(old('reference')); ?>" placeholder="e.g., Receipt #12345">
            </div>
        </div>
        
        <div class="form-group">
            <label for="description">Description</label>
            <textarea id="description" name="description" rows="3" placeholder="Transaction details..."><?php echo e(old('description')); ?></textarea>
        </div>
        
        <div class="form-actions">
            <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Record Transaction</button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/finance/transactions/create.blade.php ENDPATH**/ ?>