

<?php $__env->startSection('title', 'Transactions'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Transactions</h1>
        <p class="text-muted">View and record financial transactions</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('transactions.pending')); ?>" class="btn btn-secondary">⏳ Pending Approvals</a>
        <a href="<?php echo e(route('transactions.export', request()->query())); ?>" class="btn btn-secondary">Export CSV</a>
        <a href="<?php echo e(route('transactions.create')); ?>" class="btn btn-primary">+ Record Transaction</a>
    </div>
</div>

<!-- Filters -->
<div class="filters-card">
    <form action="<?php echo e(route('transactions.index')); ?>" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search reference or description..." value="<?php echo e(request('search')); ?>">
        </div>
        <div class="filter-group">
            <select name="type">
                <option value="">All Types</option>
                <option value="Credit" <?php echo e(request('type') == 'Credit' ? 'selected' : ''); ?>>Income (Credit)</option>
                <option value="Debit" <?php echo e(request('type') == 'Debit' ? 'selected' : ''); ?>>Expense (Debit)</option>
            </select>
        </div>
        <div class="filter-group">
            <select name="account_id">
                <option value="">All Accounts</option>
                <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($account->id); ?>" <?php echo e(request('account_id') == $account->id ? 'selected' : ''); ?>><?php echo e($account->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="filter-group">
            <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" placeholder="From">
        </div>
        <div class="filter-group">
            <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" placeholder="To">
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
        <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-link">Clear</a>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Status</th>
                <th>Account</th>
                <th>Category</th>
                <th>Amount</th>
                <th>Reference</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($transaction->date->format('d M Y')); ?></td>
                <td>
                    <span class="badge badge-<?php echo e($transaction->type == 'Credit' ? 'success' : 'danger'); ?>">
                        <?php echo e($transaction->type == 'Credit' ? '+ Income' : '- Expense'); ?>

                    </span>
                </td>
                <td>
                    <?php if($transaction->status === 'Pending'): ?>
                        <span class="badge badge-warning">⏳ Pending</span>
                    <?php elseif($transaction->status === 'Approved'): ?>
                        <span class="badge badge-success">✅ Approved</span>
                    <?php else: ?>
                        <span class="badge badge-danger">❌ Rejected</span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($transaction->account?->name); ?></td>
                <td><?php echo e($transaction->category?->name); ?></td>
                <td class="<?php echo e($transaction->type == 'Credit' ? 'text-success' : 'text-danger'); ?>">
                    <?php echo e(number_format($transaction->amount, 2)); ?>

                </td>
                <td><?php echo e($transaction->reference ?? '-'); ?></td>
                <td>
                    <div class="action-buttons">
                        <a href="<?php echo e(route('transactions.show', $transaction)); ?>" class="btn btn-sm btn-link">👁️</a>
                        <?php if($transaction->status === 'Approved'): ?>
                        <form action="<?php echo e(route('transactions.destroy', $transaction)); ?>" method="POST" style="display:inline;" data-confirm="Delete and reverse balance? This action cannot be undone.">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-link">🗑️</button>
                        </form>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="8" class="empty-state">No transactions found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($transactions->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/finance/transactions/index.blade.php ENDPATH**/ ?>